//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
 
namespace SoapInterop
{
	class SoapInteropMain
	{
		static bool Test(InteropServiceService interop)
		{
			bool retVal = true;
			try
			{
				Console.WriteLine(interop.echoInteger(1));
				Console.WriteLine(interop.echoString("To jest test"));
				Console.WriteLine(interop.echoBoolean(true));
				Console.WriteLine(interop.echoFloat(1.2F));
				Console.WriteLine(interop.echoFloat(1.23456789F));
				SOAPStruct si = new SOAPStruct();
				si.varString = "To jest cig wewntrz struktury.";
				si.varInt = 2;
				si.varFloat = 2.1F;
				SOAPStruct so = interop.echoStruct(si);
				Console.WriteLine("SOAPStruct: {0}", so.varString);
				Console.WriteLine("            {0}", so.varInt);
				Console.WriteLine("            {0}", so.varFloat);
			}
			catch(Exception e)
			{
				Console.WriteLine(e);
				retVal = false;
			}
			return retVal;
		}
		public static void Main(String[] args) 
		{
			InteropServiceService interop;
			// Baseline
			Console.WriteLine("Baseline");
			interop = new InteropServiceService ("http://www.mssoapinterop.org:80/Remoting/ServiceA.soap");
			if(!Test(interop))
				return;
			// ASP.NET Web Services
			Console.WriteLine("ASP.NET Web Services");
			interop = new InteropServiceService("http://www.mssoapinterop.org/asmx/simple.asmx");
			if(!Test(interop))
				return;
			// GLUE
			Console.WriteLine("GLUE");
			interop = new InteropServiceService ("http://12.106.211.139:8005/glue/round2");
			if(!Test(interop))
				return;
			// IONA XMLBus
			Console.WriteLine("IONA XMLBus");
			interop = new InteropServiceService ("http://interop.xmlbus.com:7002/xmlbus/container/InteropTest/BaseService/BasePort");
			if(!Test(interop))
				return;
			// MS .NET Remoting
			Console.WriteLine("MS .NET Remoting");
			interop = new InteropServiceService ("http://www.mssoapinterop.org/remoting/ServiceA.soap");
			if(!Test(interop))
				return;
			// SIM
			Console.WriteLine("SIM");
			interop = new InteropServiceService ("http://soapinterop.simdb.com/round2");
			if(!Test(interop))
				return;
			// SOAP4R
			Console.WriteLine("SOAP4R");
			interop = new InteropServiceService ("http://www.jin.gr.jp/~nahi/Ruby/SOAP4R/SOAPBuildersInterop/");
			if(!Test(interop))
				return;
			// SOAP:Lite
			Console.WriteLine("SOAP:Lite");
			interop = new InteropServiceService ("http://services.soaplite.com/interop.cgi");
			if(!Test(interop))
				return;
			// Spray 2001
			Console.WriteLine("Spray 2001");
			interop = new InteropServiceService ("http://www.dolphinharbor.org/services/interop2001");
			if(!Test(interop))
				return;
			// White Mesa SOAP Server
			Console.WriteLine("White Mesa SOAP Server");
			interop = new InteropServiceService ("http://www.whitemesa.net/interop/std");
			if(!Test(interop))
				return;

			//

			// SQLData SOAP Server
			Console.WriteLine("SQLData SOAP Server");
			interop = new InteropServiceService ("http://soapclient.com/interop/sqldatainterop.wsdl");
			if(!Test(interop))
				return;
			// EasySoap++
			Console.WriteLine("EasySoap++");
			interop = new InteropServiceService("http://easysoap.sourceforge.net/cgi-bin/interopserver");
			if(!Test(interop))
				return;

			// 4s4c
			Console.WriteLine("4s4c");
			interop = new InteropServiceService("http://soap.4s4c.com/ilab/soap.asp");
			if(!Test(interop))
				return;
			// Apache Axis
			Console.WriteLine("Apache Axis");
			interop = new InteropServiceService("http://nagoya.apache.org:5049/axis/servlet/AxisServlet");
			if(!Test(interop))
				return;
			// Apache SOAP 2.2
			Console.WriteLine("Apache SOAP 2.2");
			interop = new InteropServiceService("http://nagoya.apache.org:5049/soap/servlet/rpcrouter");
			if(!Test(interop))
				return;
			// eSOAP
			Console.WriteLine("eSOAP");
			interop = new InteropServiceService("http://212.177.97.8:8080/rpcrouter");
			if(!Test(interop))
				return;
		}
	}
}
